# サボテン
他の植物と同様に、[サボテン](objects/cactus)は土壌で育て、通常通り収穫できます。

しかし、サボテンにはさまざまなサイズがあり、奇妙な順序感覚を持っています。

完全に成長したサボテンを収穫し、隣接するすべてのサボテンがソートされた順序である場合、隣接するすべてのサボテンも再帰的に収穫します。

サボテンがソートされた順序と見なされるのは、`North` と `East` に隣接するすべてのサボテンが完全に成長し、サイズが同じかそれ以上であり、`South` と `West` に隣接するすべてのサボテンが完全に成長し、サイズが同じかそれ以下である場合です。

収穫が広がるのは、隣接するすべてのサボテンが完全に成長し、ソートされた順序である場合のみです。
つまり、成長したサボテンの正方形がサイズ順にソートされており、1つのサボテンを収穫すると、正方形全体が収穫されます。

完全に成長したサボテンは、ソートされていない場合は茶色に見えます。ソートされると、再び緑色になります。

収穫されたサボテンの数の2乗に等しいサボテンを受け取ります。つまり、`n`個のサボテンを同時に収穫すると、`n**2`個の`Items.Cactus`を受け取ります。

サボテンのサイズは `measure()` で測定できます。
それは常にこれらの数値のいずれかです: `0,1,2,3,4,5,6,7,8,9`。

`measure(direction)` に方向を渡して、ドローンのその方向の隣接タイルを測定することもできます。

`swap()` コマンドを使用して、サボテンを任意の方向の隣と交換できます。
`swap(direction)` は、ドローンの下のオブジェクトを、ドローンの `direction` に1タイル先のオブジェクトと交換します。

## 例
これらの各グリッドでは、すべてのサボテンがソートされた順序であり、収穫はフィールド全体に広がります:
`3 4 5    3 3 3    1 2 3    1 5 9
2 3 4    2 2 2    1 2 3    1 3 8
1 2 3    1 1 1    1 2 3    1 3 4`

このグリッドでは、左下のサボテンのみがソートされた順序であり、広がるには不十分です:
`1 5 3
4 9 7
3 3 2`

<spoiler=show hint 1>
行がすでにソートされている場合、列をソートしても行のソートは崩れません。
</spoiler>
<spoiler=show hint 2>
ソートアルゴリズムに慣れていない場合は、オンラインで調べて、この問題にどのアルゴリズムを適用できるか考えてみてください。隣接するサボテンしか交換できないため、すべてのアルゴリズムが機能するわけではないことに注意してください。
</spoiler>